﻿/* INTERFACE ENTRE OPEN RAILS ET UNE CARTE ARDUINO                                         Le 06/01/2026.
 Site Web : https://www.la-tour.info/uts/uts_page15.html
 Forum Web : https://www.rmf-magazine.com/phpBB/ > Section : Informatique, logiciels, trains virtuels.
 On va chercher les valeurs d'Open Rails, sur son serveur web : http://localhost:2150/API/CABCONTROLS   */
using System;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Management;
using System.Net;
using System.Threading;
using System.Windows.Forms;
namespace InterfaceORArduinoJLF
{
    public partial class Form1 : Form
    {
        //---------------------------------------------------------------------------------------------------------------
        const int nombre_de_port_maxi_const = 50;                    // Nombre de port Windows maximum marqués "Arduino".
        const int timer_trouve_port_OR_Arduino = 5000;               // Durée en msec entre deux essais de recherche de port Arduino avec Open Rails.
        const int nb_max_variable = 200;                             // On ne traite que ce nombre de variable envoyées par le site web.
        const int variable_envoi_nb_max = 100;                       // On ne traite que ce nombre de variable de noms différents.
        //---------------------------------------------------------------------------------------------------------------
        int nombre_de_port_maxi;                                     // Nombre de port Windows maximum..
        int nb_port_arduino_trouve;                                  // Nombre de port trouvés, marqués "Arduino".
        int nb_port_arduino_trouve_old;                              // Nombre de port trouvés, marqués "Arduino".
        int port_serie_or_trouve_flag;                               // 0/1/2 : 0=Pas de port Arduino présent, 1=Port Arduino présent, 2=Port Arduino Open Rails OK.
        int port_serie_or_trouve_flag_old;                           // 0/1/2 : 0=Pas de port Arduino présent, 1=Port Arduino présent, 2=Port Arduino Open Rails OK.
        int cpt1, var1;
        int[] portArduinoPresentFlag = new int[nombre_de_port_maxi_const]; // 0/1 : 1 = Carte Arduino présente.
        string[] portArduinoNom = new string[nombre_de_port_maxi_const];   // Tous les ports Arduino trouvé.  [0] = COM01 LPT1  ...[1] = COM45 Arduino
        string texte_port_arduino_nom_trouve;                        // Pour afficher la liste des ports "Arduino" trouvés.
        string texte_nom_port_name_OR;                               // Nom du port Arduino avec Open Rails trouvé.
        SerialPort serialPort = new SerialPort();
        //---------------------------------------------------------------------------------------------------------------
        int cpt2, cpt3, cpt4, var2;
        string[] variable_nom = new string[nb_max_variable];         // Nom des variables envoyées par le site web.
        string[] variable_valeur = new string[nb_max_variable];      // Valeur des variables envoyées par le site web.
        string[] variable_envoi_nom = new string[variable_envoi_nb_max];    // Nom des variables envoyées vers la carte Arduino.
        string[] variable_envoi_valeur = new string[variable_envoi_nb_max]; // Valeur des variables envoyées vers la carte Arduino.
        int[] variable_envoi_a_envoyer = new int[variable_envoi_nb_max];    // 0/1 : 1 = Variable à envoyer vers la carte Arduino.
        int nb_variable;                                             // Nombre de variable envoyées par le site web.
        int nb_variable_envoi;                                       // Nombre de variable à envoyer vers la carte Arduino.
        int debut_ligne;                                             // Variable locale traitement chaîne de caractères.
        int web_variable_init_flag;                                  // 0/1 : 0 = Premier passage dans le code de lecture de la page web.
        int probleme_ecriture_port_flag;                             // 0/1 : 1 = Problème sur la liaison vers la carte Arduino.
        int probleme_lecture_web_flag;                               // 0/1 : 1 = Problème sur le site web.
        string sURL = "http://localhost:2150/API/CABCONTROLS";       // Page web d'Open Rails.
        string texte_variable_a_envoyer;                             // Texte à envoyer sur la liaison série vers la carte Arduino.
        string texte_liste_variables_a_afficher;                     // Texte pour la fenêtre Windows.
        string texte_liste_variables_a_envoyer_a_afficher;           // Texte pour la fenêtre Windows.
        string texte_port_fixe;                                      // Texte pour la fenêtre Windows.
        //---------------------------------------------------------------------------------------------------------------
        int mode_port_automatique_flag;                              // Configuration 0/1 : 1 = Recherche de port automatique.
        int vitesse_liaison_Arduino;                                 // Configuration 1200 à 115200 : Vitesse du port série vers la carte Arduino.        
        int variable_precision;                                      // Configuration 2 à 8 : Nombre de chiffre après la virgule, sur les nombres envoyés.
        int timer_lecture_page_web;                                  // Configuration 100 à 5000 : Durée en msec entre deux lecture du site web.
        int nom_avec_Maxvalue_flag;                                  // Configuration 0/1 : 1 = Nom des variables + Valeur Maxi.
        //---------------------------------------------------------------------------------------------------------------
        Stopwatch stopWatch = new Stopwatch();
        public Form1()
        {
            // INITIALISATION PRINCIPALE :
            // Initialise les variables et le contenu de la fenêtre Windows.
            web_variable_init_flag = 0;
            nombre_de_port_maxi = 0;
            port_serie_or_trouve_flag = 0;
            port_serie_or_trouve_flag_old = 0;
            probleme_ecriture_port_flag = 0;
            probleme_lecture_web_flag = 0;
            texte_port_arduino_nom_trouve = "";
            texte_nom_port_name_OR = "";
            texte_variable_a_envoyer = "";
            texte_liste_variables_a_afficher = "";
            texte_liste_variables_a_envoyer_a_afficher = "";
            texte_port_fixe = "";
            nb_port_arduino_trouve = 0;
            nb_port_arduino_trouve_old = 0;
            nb_variable = 0;                              // 0 = Nombre de variable de la page web.
            nb_variable_envoi = 0;                        // 0 = Nombre de variable à envoyer vers la carte Arduino.
            //
            InitializeComponent();
            this.Text = "Interface Open Rails vers carte Arduino - JLF"; // Titre de la fenêtre Windows.
            textBox1.Text = "Initialisation";             // Liste des cartes Arduino sur les ports série.
            textBox2.Text = "Initialisation";             // Carte Arduino répondant Open Rails.
            textBox3.Text = "06/01/2026";                 // Date de version de ce programme.
            textBox4.Text = "Initialisation";             // Liste des variables.
            textBox5.Text = "Initialisation";             // Liste des variables envoyées.
            textBox10.Text = "Liste des variables issues du serveur web d'Open Rails"; // Titre du champ.
            pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge;
            pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
            //
            DemandeDeLecture_FichierConfiguration();      // Lecture du fichier de configuration.
            timer1.Enabled = true;
            timer1.Interval = timer_trouve_port_OR_Arduino;// Timer toutes les 5 secondes pour recherche carte Arduino.
        }
        //---------------------------------------------------------------------------------------------------------------
        private void Form1_Load(object sender, EventArgs e)
        { }

        //---------------------------------------------------------------------------------------------------------------
        //---------------------------------------------------------------------------------------------------------------
        // ON PASSE ICI TOUS LES TICS DU TIMER1 :
        // Traitement suivant "port_serie_or_trouve_flag" : 0=Connexion demandée, 1=Ports Arduino trouvés, 2=Connecté à un port Arduino Open Rails.
        //   - Connexion au serveur Web toutes les 500 msec.
        //   - Essais de connexion à la carte Arduino toutes les 5 secondes.
        //
        public void timer1_Tick(object sender, EventArgs e)
        {
            if (port_serie_or_trouve_flag == 2)
            {                                              // On a trouvé un port série avec un Arduino Open Rails. Donc c'est bon.
                timer1.Interval = timer_lecture_page_web;  // Timer toutes les 0,x secondes pour accéder à la page Web.
                DemandeDeConnexion_WebOpenRail();          // Recherche des données sur le port Web Open Rails, pour les envoyer à la carte Arduino.
                if (probleme_ecriture_port_flag == 1)
                {                                          // En fonctionnement établi, on a eu une coupure de la liaison avec la carte Arduino Open Rails !
                    probleme_ecriture_port_flag = 0;       // Efface le flag.
                    try { serialPort.Close(); }
                    catch { }
                    if (mode_port_automatique_flag == 0) texte_port_arduino_nom_trouve = "Port imposé : " + texte_port_fixe; // = "COM45".
                    else
                    {
                        textBox1.Text = "Pas de carte Arduino détectée!";
                        pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge;
                    }
                    textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                    pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                    timer1.Interval = timer_trouve_port_OR_Arduino;  // Timer toutes les 5 secondes pour recherche de carte Arduino.
                    DemandeDeConnexion_Arduino();          // Recherche de port série avec un Arduino Open Rails.
                    return;
                }
                if (probleme_lecture_web_flag == 1)
                {
                    probleme_lecture_web_flag = 0;         // Si la connexion à la page web ne marche pas, on continue aussi à vérifier la connexion à l'Arduino.
                    textBox4.Text = "Initialisation";      // Liste des variables.
                    textBox5.Text = "Initialisation";      // Liste des variables envoyeés.
                    web_variable_init_flag = 0;            // 0/1 : 0 = Premier passage dans le code de lecture de la page web, pour tout réinitialiser.
                    timer1.Interval = timer_trouve_port_OR_Arduino;    // Timer toutes les 5 secondes.
                    if (mode_port_automatique_flag == 1)
                    {       // En mode automatique, on teste la connexion avec la carte Arduino régulièrement. 
                        try { serialPort.Write("<   :JLF?:0>"); Thread.Sleep(200); } // Pause 0,2 seconde.
                        catch
                        {   // Si problème d'ecriture sur le port série!
                            try { serialPort.Close(); }
                            catch { }
                            textBox1.Text = "Pas de carte Arduino détectée!";
                            textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                            pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge;
                            pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                            timer1.Interval = timer_trouve_port_OR_Arduino;    // Timer toutes les 5 secondes pour recherche de carte Arduino.
                            DemandeDeConnexion_Arduino();  // Recherche de port série avec un Arduino Open Rails.
                            return;
                        }
                        try
                        {   // Si ecriture sur le port série = ok.
                            if (serialPort.BytesToRead > 1)
                            {
                                if (serialPort.ReadExisting() != "<JLF!>")
                                {   // Si la carte Arduino ne répond pas en mode automatique!
                                    serialPort.Close();
                                    textBox1.Text = "Pas de carte Arduino détectée!";
                                    textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                                    pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge;
                                    pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                                    timer1.Interval = timer_trouve_port_OR_Arduino;    // Timer toutes les 5 secondes pour recherche de carte Arduino.
                                    DemandeDeConnexion_Arduino(); // Recherche de port série avec un Arduino Open Rails.
                                    return;
                                }
                            }
                            else
                            {   // Si la carte Arduino ne répond pas en mode automatique!
                                serialPort.Close();
                                textBox1.Text = "Pas de carte Arduino détectée!";
                                textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                                pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge;
                                pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                                timer1.Interval = timer_trouve_port_OR_Arduino;    // Timer toutes les 5 secondes pour recherche de carte Arduino.
                                DemandeDeConnexion_Arduino();   // Recherche de port série avec un Arduino Open Rails.
                                return;
                            }
                        }
                        catch { serialPort.Close(); return; }   // Si le port série ne répond pas.

                    }
                    else
                    {   // En mode avec un port fixe "COM45", on vérifie régulièrement si la connexion avec la carte Arduino reste active.
                        try
                        {
                            if (!serialPort.IsOpen)
                            {   // Si la carte Arduino n'est plus active!
                                texte_port_arduino_nom_trouve = "Port imposé : " + texte_port_fixe; // = "COM45".
                                textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                                pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                                timer1.Interval = timer_trouve_port_OR_Arduino;    // Timer toutes les 5 secondes pour recherche de carte Arduino.
                                DemandeDeConnexion_Arduino();   // Recherche de port série avec un Arduino Open Rails.
                                return;
                            }
                        }
                        catch { return; }
                    }
                }
            }
            else if ((port_serie_or_trouve_flag == 0) || (port_serie_or_trouve_flag == 1)) // Pas de carte Arduino Open RAils de trouvé !
            {   // On est dans le cas, où la carte Arduino n'a pas encore été trouvée. "port_serie_or_trouve_flag" = 0 ou 1.
                port_serie_or_trouve_flag_old = 0;   // On impose une raz ici, en cas de reset sur la carte Arduino. 
                timer1.Interval = timer_trouve_port_OR_Arduino; // Timer toutes les 5 secondes pour recherche carte Arduino.
                DemandeDeConnexion_Arduino();        // Recherche de port série avec un Arduino Open Rails.
            }
        }
        //---------------------------------------------------------------------------------------------------------------
        //---------------------------------------------------------------------------------------------------------------
        // RECHERCHE DU PORT SERIE AVEC ARDUINO OPEN RAILS.
        // En entrée :
        //    - "port_serie_or_trouve_flag"   0 = Pas de port Arduino de trouvé,
        //                                    1 = Pas de port Arduino Open Rails de trouvé.
        // En retour :
        //    - "port_serie_or_trouve_flag"   0 = Pas de port Arduino de trouvé,
        //                                    1 = Pas de port Arduino Open Rails de trouvé,
        //                                    2 = Connexion avec la carte Arduino Open Rails établie.
        public void DemandeDeConnexion_Arduino()
        {
            if (mode_port_automatique_flag == 1)
            {   // En mode automatique, on recherche tous les ports marqués "Arduino". 
                // Instruction using() : Garantir l’utilisation correcte des objets supprimables.
                using (var searcher = new ManagementObjectSearcher("SELECT * FROM WIN32_SerialPort"))
                {   //
                    // RECHERCHE LES PORTS SERIE.
                    string[] portnames = SerialPort.GetPortNames();
                    var liste_ports = searcher.Get().Cast<ManagementBaseObject>().ToList();
                    nombre_de_port_maxi = liste_ports.Count;
                    //int.TryParse(liste_ports.Count, out nombre_de_port_maxi));
                    if (nombre_de_port_maxi > nombre_de_port_maxi_const) nombre_de_port_maxi = nombre_de_port_maxi_const;
                    var tList = (from n in portnames
                                 join p in liste_ports on n equals p["DeviceID"].ToString()
                                 select n + " - " + p["Caption"]).ToList();
                    for (cpt1 = 0; cpt1 < nombre_de_port_maxi_const; cpt1++) portArduinoPresentFlag[cpt1] = 0; // Raz au début.
                    // tList = Liste des ports Windows (Exemple) :
                    //   tList[0] = "COM1 - Port de communication (COM1)"
                    //   tList[1] = "COM10 - Arduino Due (COM10)"
                    //   tList[2] = "COM45 - Arduino Due Programming Port (COM45)"
                    //
                    // RECHERCHE LES PORTS SERIE AVEC DES ARDUINOS DE BRANCHE.
                    for (cpt1 = 0; cpt1 < nombre_de_port_maxi_const; cpt1++) portArduinoPresentFlag[cpt1] = 0; // Raz au début.
                    cpt1 = 0; // Nombre de port valide.
                    cpt2 = 0; // Nombre de port valide et "Arduino".
                    foreach (string s in tList)
                    {
                        if ((s.Contains("Arduino")) && (cpt2 < nombre_de_port_maxi))
                        {
                            if ((cpt1 == 0) || ((cpt1 > 0) && (s != portArduinoNom[cpt1 - 1]))) // Pour éviter des doublons, dans certains cas les ports sont répétés.
                            { portArduinoPresentFlag[cpt1] = 1; portArduinoNom[cpt1] = s; cpt1++; }
                        }
                        cpt2++;
                    }
                    nb_port_arduino_trouve = cpt1;
                    // nb_port_arduino_trouve = Nombre de ports série trouvés et marqué "Arduino".
                    // Liste des ports Windows trouvé marqué "Arduino" = "portArduinoPresentFlag[]" + "portArduinoNom[]".
                    // Exemple :
                    //   portArduinoPresentFlag[0] = 1   |   portArduinoNom[0] = "COM10 - Arduino Due (COM10)"
                    //   portArduinoPresentFlag[1] = 1   |   portArduinoNom[1] = "COM45 - Arduino Due Programming Port (COM45)"
                    // SI IL EXISTE AU MOINS UN PORT MARQUE ARDUINO, LANCER UN TEST OPEN RAILS.
                    if (nb_port_arduino_trouve > 0)
                    {   // On a au moins un port série de type Arduino. En mode automatique, on teste ces ports, pour savoir si c'est un Arduino Open Rails ?
                        texte_port_arduino_nom_trouve = "";
                        for (cpt1 = 0; cpt1 < nb_port_arduino_trouve; cpt1++)
                        {
                            if (portArduinoPresentFlag[cpt1] == 1)
                            {
                                texte_port_arduino_nom_trouve += portArduinoNom[cpt1] + "\r\n"; // Pour afficher sur la fenêtre Windows.
                                nb_port_arduino_trouve_old = -1; // Pour forcer l'affichage.
                            }
                        }
                        // On a la liste des ports avec un Arduino, dans "portArduinoNom[x]".
                        port_serie_or_trouve_flag = 0;  // On continu en boucle, pour trouver la bonne carte Arduino Open Rails.
                        serialPort.BaudRate = vitesse_liaison_Arduino;
                        serialPort.WriteTimeout = 200;  // Sinon ça coince sur certains port usb!
                        serialPort.ReadTimeout = 200;   // Sinon ça coince sur certains port usb!
                        for (cpt1 = 0; ((cpt1 < nb_port_arduino_trouve) && (port_serie_or_trouve_flag == 0)); cpt1++)
                        {
                            port_serie_or_trouve_flag = 0;
                            if (portArduinoPresentFlag[cpt1] == 1)
                            {
                                try { serialPort.Close(); }
                                catch { }
                                serialPort.PortName = portArduinoNom[cpt1].Substring(0, 5).Replace(" ", string.Empty); // = "COM45"
                                port_serie_or_trouve_flag = 1;
                                try { serialPort.Open(); Thread.Sleep(300); }   // Pause 0,3 seconde.
                                catch { port_serie_or_trouve_flag = 0; }
                            }
                            if (port_serie_or_trouve_flag == 1)
                            {
                                port_serie_or_trouve_flag = 0;
                                try
                                {
                                    serialPort.Write("<   :JLF?:0>");           // Envoi la chaine : "<   :JLF?:0>"
                                    Thread.Sleep(300);                          // Pause 0,3 seconde.
                                    var1 = 0;
                                    try
                                    {
                                        var1 = serialPort.BytesToRead;
                                        if (var1 > 1)
                                        {
                                            if (serialPort.ReadExisting() == "<JLF!>")  // Attend en retour la chaine : "<JLF!>"
                                            { port_serie_or_trouve_flag = 2; texte_nom_port_name_OR = serialPort.PortName; }
                                            else { serialPort.Close(); }
                                        }
                                    }
                                    catch { }
                                }
                                catch { serialPort.Close(); }
                            }
                        }
                    }
                    else { port_serie_or_trouve_flag = 0; } // Pas trouvé de port série avec une carte Arduino Open Rails !
                }
            }
            else
            {  // En mode "Port Fixe", le port est imposé : "texte_port_fixe" = "COM45".
                serialPort.BaudRate = vitesse_liaison_Arduino;
                serialPort.PortName = texte_port_fixe;    // = "COM45".
                texte_nom_port_name_OR = texte_port_fixe; // = "COM45".
                texte_port_arduino_nom_trouve = "Port imposé : " + texte_port_fixe; // = "Port imposé : COM45".
                nb_port_arduino_trouve = 1;               // On a bien 1 port série avec Arduino, d'office.
                port_serie_or_trouve_flag = 2;            // Le port série est un port série Arduino, avec Open Rails.
                pictureBox1.Image = Properties.Resources.rectangle_74x125_vert;
                try { serialPort.Open(); Thread.Sleep(300); }   // Pause 0,3 seconde.
                catch { port_serie_or_trouve_flag = 0; }
            }
            if (nb_port_arduino_trouve != nb_port_arduino_trouve_old)
            { // Si le nombre de port détectés a changé, on affiche la liste à jour sur la fenêtre Windows.
                if (nb_port_arduino_trouve > 0)
                {   // Affiche la nouvelle liste des ports série Arduino trouvés.
                    textBox1.Text = texte_port_arduino_nom_trouve;
                    pictureBox1.Image = Properties.Resources.rectangle_74x125_vert;
                }
                else
                {   // Affiche "Pas de carte Arduino détectée!", si l'on est en mode automatique.
                    if (mode_port_automatique_flag == 1)  /// = "COM45".
                    {
                        textBox1.Text = "Pas de carte Arduino détectée!";
                        pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge;
                    }
                }
                nb_port_arduino_trouve_old = nb_port_arduino_trouve;
            }
            // Si l'état actuel a changé, on met à jour les listes et les rectanges de couleur sur la fenêtre Windows.
            if (port_serie_or_trouve_flag_old != port_serie_or_trouve_flag)
            {
                if ((port_serie_or_trouve_flag_old == 0) && (port_serie_or_trouve_flag == 1))
                {
                    pictureBox1.Image = Properties.Resources.rectangle_74x125_vert;
                }
                else if ((port_serie_or_trouve_flag_old == 0) && (port_serie_or_trouve_flag == 2))
                {
                    pictureBox1.Image = Properties.Resources.rectangle_74x125_vert;
                    pictureBox2.Image = Properties.Resources.rectangle_74x20_vert;
                    textBox2.Text = "Arduino avec Open Rails détectée en : " + texte_nom_port_name_OR;
                }
                else if ((port_serie_or_trouve_flag_old == 1) && (port_serie_or_trouve_flag == 2))
                {
                    pictureBox2.Image = Properties.Resources.rectangle_74x20_vert;
                    textBox2.Text = "Arduino avec Open Rails détectée en : " + texte_nom_port_name_OR;
                }

                else if ((port_serie_or_trouve_flag_old == 2) && (port_serie_or_trouve_flag == 1))
                {
                    pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                    textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                }
                else if ((port_serie_or_trouve_flag_old == 2) && (port_serie_or_trouve_flag == 0))
                {
                    if (mode_port_automatique_flag == 1)
                    { pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge; }
                    pictureBox2.Image = Properties.Resources.rectangle_74x20_rouge;
                    textBox2.Text = "Pas de carte Arduino détectée avec Open Rails !";
                }
                else if ((port_serie_or_trouve_flag_old == 1) && (port_serie_or_trouve_flag == 0))
                {
                    if (mode_port_automatique_flag == 1)
                    { pictureBox1.Image = Properties.Resources.rectangle_74x125_rouge; }
                    textBox1.Text = "Pas de carte Arduino détectée!";
                }
                port_serie_or_trouve_flag_old = port_serie_or_trouve_flag;
            }
        }
        //---------------------------------------------------------------------------------------------------------------
        //---------------------------------------------------------------------------------------------------------------
        // RECHERCHE DES DONNEES SUR LA PAGE WEB OPEN RAILS, POUR LES ENVOYER A LA CARTE ARDUINO.
        // En entrée :
        //     -  "port_serie_or_trouve_flag" = 2       2 = Connexion établie avec la carte Arduino Opens Rails.
        // En retour :
        //     - "probleme_lecture_web_flag"   = 0/1 :  1 = Problème d'accès à la page Web d'Open Rails.
        //     - "probleme_ecriture_port_flag" = 0/1 :  1 = Coupure de la liaison avec la carte Arduino Open Rails !
        public void DemandeDeConnexion_WebOpenRail()
        {
            WebRequest wrGETURL;
            wrGETURL = WebRequest.Create(sURL);
            wrGETURL.Timeout = 500;
            // WebProxy myProxy = new WebProxy("myproxy", 80); myProxy.BypassProxyOnLocal = true; wrGETURL.Proxy = WebProxy.GetDefaultProxy(); // Inutile ici.
            Stream objStream;
            try { objStream = wrGETURL.GetResponse().GetResponseStream(); }
            catch { probleme_lecture_web_flag = 1; return; }
            StreamReader objReader = new StreamReader(objStream);
            string sLine = "";
            cpt2 = 0;
            if (web_variable_init_flag == 0)
            { // Si premier passage initial.
                nb_variable_envoi = 0;
                for (cpt2 = 0; cpt2 < nb_max_variable; cpt2++) { variable_nom[cpt2] = ""; variable_valeur[cpt2] = ""; }
                for (cpt2 = 0; cpt2 < variable_envoi_nb_max; cpt2++) { variable_envoi_nom[cpt2] = ""; variable_envoi_valeur[cpt2] = ""; variable_envoi_a_envoyer[cpt2] = 0; }
            }
            debut_ligne = 0;                   // Pour l'analyse des trames reçues.
            cpt2 = 0;                          // Compteur pour le nombre de variables reçues.
            while (sLine != null)
            {   // sline = Toutes les lignes recçues du serveur web Open Rails.
                try { sLine = objReader.ReadLine(); }                                    // Une ligne de texte reçue du serveur Web.
                catch { probleme_lecture_web_flag = 1; return; }
                if ((sLine != null) && (cpt2 < nb_max_variable))
                {
                    if (sLine == "[") { debut_ligne = 1; }                               // Début de la page web.
                    else if ((debut_ligne == 1) && ((sLine == "  {") || (sLine == " {") || (sLine == "{"))) { debut_ligne = 2; } // Début de la variable.
                    else if (debut_ligne == 2)
                    {
                        if (sLine.Contains("TypeName"))                                  // "TypeName : ORTS_TCS1,".
                        {
                            string[] words = sLine.Split('"');
                            variable_nom[cpt2] = words[3];                               // [0]=   ,[1]="TypeName", [2]= :   ,[3]="ORTS_TCS1",  [4]=,
                            debut_ligne = 3;
                        }
                    }
                    else if (debut_ligne == 3)
                    {
                        if (sLine.Contains("MaxValue") && (nom_avec_Maxvalue_flag == 1)) // "MaxValue : 1.0,"
                        {
                            string[] words = sLine.Split('"');
                            var2 = words[2].Length;
                            variable_nom[cpt2] += "_" + words[2].Substring(2, var2 - 3); // [0]=   ,[1]="MaxValue",   [2] = ": 1.0,"
                        }
                        if (sLine.Contains("RangeFraction"))                             // "RangeFraction": 0.0" = Dernier champs de la variable.
                        {
                            string[] words = sLine.Split('"');
                            variable_valeur[cpt2] = words[2];                            // [0]=    ,[1]="RangeFraction", [2]=:0.0
                            debut_ligne = 4;
                            cpt2++;
                        }
                    }
                    else if ((sLine == "  },") || (sLine == " },") || (sLine == "},"))
                    {
                        debut_ligne = 1;
                    }
                }
            }
            nb_variable = cpt2;
            if (nb_variable > nb_max_variable) nb_variable = nb_max_variable;  // Sécurité.
            //------------------------------------------------------------------------------------------------------------------
            // TABLEAUX RENSEIGNES :
            //    nb_variable
            //    variable_nom[nb_variable]
            //    variable_valeur[nb_variable]
            if (nb_variable > 0)
            {
                if (web_variable_init_flag == 0)
                // PREMIER PASSAGE : CREATION DU TABLEAU D'ENVOI :
                // On supprime les doublons dans variable_envoi_nom[].
                {
                    for (cpt3 = 0; cpt3 < variable_envoi_nb_max; cpt3++) { variable_envoi_nom[cpt3] = ""; variable_envoi_valeur[cpt3] = ""; }
                    for (cpt3 = 0; cpt3 < nb_variable; cpt3++)
                    {
                        var2 = 0;
                        for (cpt4 = 0; cpt4 < nb_variable_envoi; cpt4++) // Variable déjà dans le tableau "variable_envoi_nom[cpt4]" ?
                        {
                            if (variable_nom[cpt3] == variable_envoi_nom[cpt4]) { var2 = 1; break; }
                        }
                        if (var2 == 0) // Premiere fois que l'on trouve ce nom de variable.
                        {
                            variable_envoi_nom[cpt4] = variable_nom[cpt3];
                            variable_envoi_valeur[cpt4] = variable_valeur[cpt3];
                            variable_envoi_a_envoyer[cpt4] = 1;
                            nb_variable_envoi++;
                        }
                    }
                    if (nb_variable_envoi > variable_envoi_nb_max) nb_variable_envoi = variable_envoi_nb_max;  // Sécurité.
                    textBox10.Text = "Liste des variables issues du serveur web d'Open Rails (" +
                        Convert.ToString(nb_variable_envoi) + "/" + Convert.ToString(nb_variable) + ")"; // Titre du champ.
                    web_variable_init_flag = 1; // On ne repassera plus dans cette boucle.
                }
                else if (web_variable_init_flag == 1)
                // PASSAGES SUIVANTS : MODIFICATION DU TABLEAU D'ENVOI DES VARIABLES
                // Si la valeur a changé, on renseigne "variable_envoi_nom[]" + "variable_envoi_valeur".
                {
                    for (cpt3 = 0; cpt3 < nb_variable; cpt3++)
                    {
                        var2 = 0;
                        for (cpt4 = 0; cpt4 < nb_variable_envoi; cpt4++)
                        {
                            if (variable_nom[cpt3] == variable_envoi_nom[cpt4])
                            {
                                var2 = 1; break;
                            }
                        }
                        if (var2 == 1) // On vient de trouver "cpt4" où est stockée l'ancienne valeur.
                        {
                            if ((variable_envoi_valeur[cpt4] != variable_valeur[cpt3]) && (variable_envoi_a_envoyer[cpt4] == 0))
                            {
                                if (variable_envoi_a_envoyer[cpt4] == 0)
                                {   // Si la valeur est différente, on va l'envoyer à l'Arduino.
                                    if ((variable_envoi_valeur[cpt4].Length > variable_precision) && (variable_valeur[cpt3].Length > variable_precision)) // On limite la comparaison à 5 chiffres après la virgule.
                                    { // Si la valeur est de type ": 0.64999997615814209", on ne compare que les 7/8 premiers caractères.
                                        if (variable_envoi_valeur[cpt4].Substring(0, variable_precision) != variable_valeur[cpt3].Substring(0, variable_precision))
                                        {
                                            variable_envoi_a_envoyer[cpt4] = 1;  // Valeur modifiée => Valeur à envoyer.
                                        }
                                    }
                                    else
                                    { // Si la valeur est de type ": 0.0" ou ": 1.0", on compare tous les caractères.
                                        variable_envoi_a_envoyer[cpt4] = 1;      // Valeur modifiée => Valeur à envoyer.
                                    }
                                    variable_envoi_valeur[cpt4] = variable_valeur[cpt3];
                                }
                            }
                        }
                    }
                }
                // AFFICHAGE DE LA LISTE DES VARIABLES SUR LA FENETRE WINDOWS.
                texte_liste_variables_a_afficher = "";
                for (cpt4 = 0; cpt4 < nb_variable_envoi; cpt4++)
                {  // En utilisant "texte_liste_variables_a_afficher +=", plutôt que "textBox4.Text +=", on gagne 20 msec.
                    texte_liste_variables_a_afficher += variable_envoi_nom[cpt4] + variable_envoi_valeur[cpt4] + "\r\n";
                }
                textBox4.Text = texte_liste_variables_a_afficher;
                texte_liste_variables_a_envoyer_a_afficher = "";
                // ENVOI DU TABLEAU VERS L'ARDUINO.
                for (cpt4 = 0; cpt4 < nb_variable_envoi; cpt4++)
                {
                    if (variable_envoi_a_envoyer[cpt4] == 1)
                    {
                        if (variable_envoi_valeur[cpt4].Length > variable_precision) // On limite à x chiffres après la virgule.
                        { texte_variable_a_envoyer = "<  :" + variable_envoi_nom[cpt4] + variable_envoi_valeur[cpt4].Substring(0, variable_precision) + ">"; }
                        else
                        { texte_variable_a_envoyer = "<  :" + variable_envoi_nom[cpt4] + variable_envoi_valeur[cpt4] + ">"; }
                        variable_envoi_a_envoyer[cpt4] = 0;
                        texte_liste_variables_a_envoyer_a_afficher += texte_variable_a_envoyer + "\r\n";  // Affiche de la liste des variables envoyées, sur la fenêtre Windows, 
                        try { serialPort.Write(texte_variable_a_envoyer); }
                        catch
                        {                                          // Si le Write vers Arduino se passe mal, 
                            probleme_ecriture_port_flag = 1;            // on coupe la liaison pour la rétablir !
                            web_variable_init_flag = 0;                     // On efface tout !
                            textBox5.Text = "Initialisation";      // Liste des variables envoyeés.
                            for (cpt4 = 0; cpt4 < variable_envoi_nb_max; cpt4++)
                            {
                                variable_envoi_a_envoyer[cpt4] = 1; // Pour renvoyer toutes les variables à la prochaine connexion.
                            }
                            return;
                        }
                    }
                }
                if (texte_liste_variables_a_envoyer_a_afficher.Length > 5) textBox5.Text = texte_liste_variables_a_envoyer_a_afficher;
            }
        }
        //---------------------------------------------------------------------------------------------------------------
        //---------------------------------------------------------------------------------------------------------------
        // LECTURE DU FICHIER DE CONFIGURATION.
        // En entrée :
        // En retour :
        //   Si les paramètres sont hors limites, les cases de la fenêtre Windows seront en jaune.
        //   - mode_port_automatique_flag;     //  0/1 : 1 = Recherche de port automatique.
        //   - vitesse_liaison_Arduino;   //  1200 à 115200 : Vitesse du port série vers la carte Arduino.        
        //   - variable_precision;        //  2 à 8 : Nombre de chiffre après la virgule, sur les nombres envoyés.
        //   - timer_lecture_page_web;    //  100 à 5000 : Durée en msec entre deux lecture du site web.
        //   - nom_avec_Maxvalue_flag;    //  0/1 : 1 = Nom des variables + Valeur Maxi.
        /*
         Contenu du fichier de configuration : "InterfaceORArduinoJLF_config.txt".
         * ------------------------------------------------------------------------------------------------------------------------------------------
         port = auto
         * port = Port de l'Arduino. Si "auto", on cherche un Arduino qui répond "<JLF!>" à l'envoi de "<   :JLF?:0>". Par défaut = auto.
         * port = COM01, COM22, COM45, auto
         * ------------------------------------------------------------------------------------------------------------------------------------------
         vitesse = 38400
         * vitesse = Débit en baud de la liaison avec la carte Arduino Open Rails.Par défaut = 38400.
         * vitesse
         * = 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800
         * ------------------------------------------------------------------------------------------------------------------------------------------
         precision = 3
         * precision = Sur les valeurs transmises à l'Arduino. Nombre de chiffre après la virgule, 2="0,51"=1%,   3="0,514"=0,1%,   4="0,5148"=0,01%. Par défaut = 3.
         * precision = Eviter > 4, car certaines variables sont instables, et si elles changent souvent de valeurs, elles sont transmises à chaque fois à l'Arduino.
         * precision = En pratique prendre 3 pour avoir suffisamment de précision.On peut afficher 380 km/h sans soucis.
         * precision = 2, 3, 4, 5, 6, 7, 8
         * ------------------------------------------------------------------------------------------------------------------------------------------
         timer = 200
         * timer = Intervalle en milli secondes entre deux lectures de la page web d'Open Rails. Par défaut = 500 (2 fois par seconde), mais 200 fonctionne bien.
         * timer = 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 5000
         * ------------------------------------------------------------------------------------------------------------------------------------------
         nomavecmaxi = oui
         * nomavecmaxi = Le programme reçoit plusieurs variables de noms identiques, et ne conservera qu'une seule variable à envoyer.     Par défaut = oui.
         * nomavecmaxi = Dans ce cas, il faudra reprendre le fichier " Locomotive.cvf", en différenciant les nom des variables. 
         * nomavecmaxi = "oui" => Dans ce cas le programme ajoute la valeur "MaxValue" à la fin du nom de variable,.
         * nomavecmaxi = Exemple : "SPEEDOMETER_160", avec MaxValue = 160 à la fin du nom.Ca améliore la différentiation des variables au nom identique.
         * nomavecmaxi = oui, non
         */
        public void DemandeDeLecture_FichierConfiguration()
        {
            mode_port_automatique_flag = 0;           // Configuration 0/1 : 1 = Recherche de port automatique.
            vitesse_liaison_Arduino = 0;         // Configuration 1200 à 115200 : Vitesse du port série vers la carte Arduino.        
            variable_precision = 0;              // Configuration 2 à 8 : Nombre de chiffre après la virgule, sur les nombres envoyés.
            timer_lecture_page_web = 0;          // Configuration 100 à 5000 : Durée en msec entre deux lecture du site web.
            nom_avec_Maxvalue_flag = -1;                                 // Configuration 0/1 : 1 = Nom des variables + Valeur Maxi.
            try
            { // Lecture du fichier de configuration.
                StreamReader monStreamReader = new StreamReader("InterfaceORArduinoJLF_config.txt");
                string ligne = monStreamReader.ReadLine();
                while (ligne != null)
                {
                    ligne = monStreamReader.ReadLine();
                    if ((ligne != null) && (ligne.Length > 5))
                    {
                        if (ligne.Substring(0, 1) != "*")   // On saute les ligne commençant par '*' = Lignes de commentaires.
                        {
                            string[] words = ligne.Split(' ');
                            if (words.Length == 3)          //  On découpe le texte :   "port = 38400"   =>   "port" + "=" + "38400".
                            {
                                if (words[0] == "port")
                                {
                                    if (words[2] == "auto") { mode_port_automatique_flag = 1; } // COM10, COM45, auto
                                    else if ((words[2].Substring(0, 3) == "COM") && (words[2].Length == 5))
                                    {
                                        if (int.TryParse(words[2].Substring(3, 2), out var1))
                                        {
                                            if ((var1 >= 1) || (var1 <= 99)) texte_port_fixe = words[2]; // texte_port_fixe = "COM45".
                                        }
                                    }
                                }
                                if (words[0] == "vitesse") // 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800
                                {
                                    if (words[2] == "2400") vitesse_liaison_Arduino = 2400;
                                    else if (words[2] == "4800") vitesse_liaison_Arduino = 4800;
                                    else if (words[2] == "9600") vitesse_liaison_Arduino = 9600;
                                    else if (words[2] == "14400") vitesse_liaison_Arduino = 14400;
                                    else if (words[2] == "19200") vitesse_liaison_Arduino = 19200;
                                    else if (words[2] == "38400") vitesse_liaison_Arduino = 38400;
                                    else if (words[2] == "57600") vitesse_liaison_Arduino = 57600;
                                    else if (words[2] == "115200") vitesse_liaison_Arduino = 115200;
                                    else if (words[2] == "230400") vitesse_liaison_Arduino = 230400;
                                    else if (words[2] == "460800") vitesse_liaison_Arduino = 460800;
                                    else { vitesse_liaison_Arduino = 38400; textBox6.BackColor = Color.Yellow; }
                                }
                                if (words[0] == "precision") // 2, 3, 4, 5, 6, 7, 8
                                {
                                    if (words[2] == "2") variable_precision = 2;
                                    else if (words[2] == "3") variable_precision = 3;
                                    else if (words[2] == "4") variable_precision = 4;
                                    else if (words[2] == "5") variable_precision = 5;
                                    else if (words[2] == "6") variable_precision = 6;
                                    else if (words[2] == "7") variable_precision = 7;
                                    else if (words[2] == "8") variable_precision = 8;
                                    else { variable_precision = 3; textBox8.BackColor = Color.Yellow; }
                                }
                                if (words[0] == "timer") // 100 à 5000
                                {
                                    if (int.TryParse(words[2], out var1))
                                    {
                                        if ((var1 >= 100) || (var1 <= 5000)) timer_lecture_page_web = var1;
                                        else { timer_lecture_page_web = 500; textBox7.BackColor = Color.Yellow; }
                                    }
                                    else timer_lecture_page_web = 0;
                                }
                                if (words[0] == "nomavecmaxi") // oui, non
                                {
                                    if (words[2] == "oui") nom_avec_Maxvalue_flag = 1;
                                    else if (words[2] == "non") nom_avec_Maxvalue_flag = 0;
                                    else { nom_avec_Maxvalue_flag = 0; textBox9.BackColor = Color.Yellow; }
                                }
                            }
                        }
                    }
                }
                monStreamReader.Close();
            }
            catch { }
            if (mode_port_automatique_flag == 0)
            {                                                                   // texte_port_fixe = auto ou COMxx, sinon erreur.
                if ((texte_port_fixe.Length != 5) || (texte_port_fixe.Substring(0, 3) != "COM")) { mode_port_automatique_flag = 1; textBox1.BackColor = Color.Yellow; }
            }
            //
            if (vitesse_liaison_Arduino == 0) { vitesse_liaison_Arduino = 38400; textBox6.BackColor = Color.Yellow; }
            textBox6.Text = Convert.ToString(vitesse_liaison_Arduino) + " bps"; // Vitesse liaison vers carte Arduino.
                                                                                //
            if (variable_precision == 0) { variable_precision = 3; textBox8.BackColor = Color.Yellow; }
            textBox8.Text = Convert.ToString(variable_precision) + " ch. après v."; // Précision des valeurs envoyées.
            variable_precision += 4;                                            // 3/4 => 7/8 : Pour tronquer les valeurs envoyées à 3 ou 4 chiffres après la virgule.
                                                                                //
            if ((timer_lecture_page_web < 100) || (timer_lecture_page_web > 5000)) { timer_lecture_page_web = 500; textBox7.BackColor = Color.Yellow; }
            textBox7.Text = Convert.ToString(timer_lecture_page_web) + " ms";   // Timer lecture de la page web.
                                                                                //
            if (nom_avec_Maxvalue_flag == -1) { nom_avec_Maxvalue_flag = 0; textBox9.BackColor = Color.Yellow; }
            if (nom_avec_Maxvalue_flag == 1) textBox9.Text = "nom + maxi";      // Nom des variables avec l'ajout "MaxValue".
            else textBox9.Text = "nom simple";
        }
    }
}